
#################################
#################################
## pathview
#################################
#################################

# color KEGG maps by differential expression: 
# options:  by fold-change, by signed log p-value, by test stat
run.pathview = function(DEresult, 
                        keggIDs,
                        #colorscheme = c("tstat","estimate"), <--------------------estimate is not being used
                        colorscheme = c("tstat","DE"),
                        pvalthresh=0.05, 
                        view=c("KEGG","graphviz"),
                        #kegg.dir=NULL, <------------------------------------------currently not being used
                        #xml.files=NULL,<------------------------------------------currently not being used
                        predictors=NULL,
                        path.to.pathview.results,
                        log,
                        path.results,
                        path.inc,
                        path.to.csvs)   
{
  wtmp <- character(0)
 # extract the species from the KEGG IDs:
  pathview.species = substr(keggIDs[1],1,3)

  suppressMessages(library(pathview))
  colorscheme <- match.arg(arg = colorscheme)
  
  J = DEresult$npredictors
  print("Starting pathview analysis")
  cat("LOG:Starting pathview analysis",file=log,sep='\n\n',append=TRUE)
  cat("document.write('<p>Starting pathview analysis</p>');", file=paste(path.inc,"//status.js",sep=""),append=TRUE)
  
  d=FALSE
  
  maindir = getwd()
  setwd(path.to.pathview.results)

  for(j in 1:J)
  {

    if(colorscheme=="tstat")
    {
      # wts = as.matrix(DEresult$ests[,1:J]/DEresult$ses[,1:J])
      # wts = DEresult$out.df["Log2 fold change",1:J]/DEresult$out.df["std error",1:J]
      
      wts = DEresult$out.df.list[[j]]  #[,c("Log2 fold change", "geneName", "Accession.Number")] 
      
      wts$weights.trunc    <- wts[,"Log2 fold change"]/wts[,"std error"]
      
      wts.b                <- aggregate(wts[,c("weights.trunc")], by = list(wts[,c("Official.Gene.Name")]), sum, na.rm = T, simplify = F)  # wts[,c("weights.trunc", "Official.Gene.Name")]
      colnames(wts.b)      <- c("Official.Gene.Name", "weights.trunc")
      rownames(wts.b)      <- wts.b[,"Official.Gene.Name"] 
      
      wts.c                <- as.matrix(as.numeric(wts.b[,"weights.trunc"]))
      dimnames(wts.c)[[1]] <- wts.b[,"Official.Gene.Name"]
      dimnames(wts.c)[[2]] <- dimnames(DEresult$ests)[[2]][j]    #[1:J]
      colnames(wts.c)      <- make.names(colnames(wts.c))
      
    }

    if(colorscheme=="DE")
    {
      # jbucci - 11/4/2015
      wts = DEresult$out.df.list[[j]]  #[,c("Log2 fold change", "geneName", "Accession.Number")] 
      
      # truncate the weights:
      #  wts[,1:J] = wts[,1:J]*(DEresult$pvals[,1:J]<pvalthresh)
      #  dimnames(wts)[[2]] = dimnames(DEresult$ests)[[2]][1:J]
      #  colnames(wts)=make.names(colnames(wts))
      
      wts$weights.trunc    <- wts[,"Log2 fold change"]*(wts[,"P-value"]<pvalthresh)       # (DEresult$pvals[,1:J]<pvalthresh)
      wts.b                <- aggregate(wts[,c("weights.trunc")], by = list(wts[,c("Official.Gene.Name")]), sum, na.rm = T, simplify = F)  # wts[,c("weights.trunc", "Official.Gene.Name")]
      colnames(wts.b)      <- c("Official.Gene.Name", "weights.trunc")
      rownames(wts.b)      <- wts.b[,"Official.Gene.Name"] 
      
      wts.c                <- as.matrix(as.numeric(wts.b[,"weights.trunc"]))
      dimnames(wts.c)[[1]] <- wts.b[,"Official.Gene.Name"]
      dimnames(wts.c)[[2]] <- dimnames(DEresult$ests)[[2]][j]    #[1:J]
      colnames(wts.c)      <- make.names(colnames(wts.c))
    }


#  write.csv(wts,file=paste(path.to.csvs,"//pathview - weights_original.csv",sep=""))
#  write.csv(wts.c,file=paste(path.to.csvs,"//pathview - weights.csv",sep=""))
#  write.csv(DEresult$pvals,file=paste(path.to.csvs,"//pathview - pvals.csv",sep=""))
#  write.csv(DEresult$ests,file=paste(path.to.csvs,"//pathview - ests.csv",sep=""))


    # loop through specified keggIDs:
    if(length(keggIDs)>0)
    {
      for(k in 1:length(keggIDs))
      {
        if(!d){
          print(paste("Downloading KEGG files for", keggIDs[k]," pathway ",k,"/",length(keggIDs)))
          cat(paste("LOG:Downloading KEGG files for", keggIDs[k]," pathway ",k,"/",length(keggIDs)),file=log,sep='\n\n',append=TRUE)
          cat(paste("document.write('<p>Downloading KEGG files for", keggIDs[k]," pathway ",k,"/",length(keggIDs)," </p>');"), file=paste(path.inc,"//status.js",sep=""),append=TRUE)
        }
        if(colorscheme=="DE"){genelimit = c(-2.5,2.5)}
        if(colorscheme=="tstat"){genelimit = c(-10,10)}
        
		# infer species:


        # run pathview for the appropriate ID:
        if(view=="KEGG")
        {
          pv <- suppressMessages(suppressWarnings(try(pathview(gene.data = wts.c[,1], 
                                                               cpd.data=NULL,
                                                               pathway.id =  keggIDs[k],#"04110", #sel.2paths[1],#"hsa01100",#,
                                                               species = pathview.species,
                                                               out.suffix = make.names(dimnames(wts.c)[[2]][1]),
                                                               kegg.native = TRUE,
                                                               limit=list(gene=genelimit,cpd=c(-1,1)),
                                                               gene.idtype="Symbol",
                                                               multi.state=FALSE,
                                                               same.layer=TRUE,
                                                               discrete =list(gene=FALSE, cpd=FALSE)))))   # "ACCNUM"Symbol
          if(!is.list(pv))
            wtmp <- paste(wtmp,"Error occurred with KEGG pathway",keggIDs[k],"\n")
            
        }
        if(view=="graphviz")
        {
          pv <- suppressMessages(suppressWarnings(try(pathview(gene.data = wts.c[,1], cpd.data=NULL,pathway.id = keggIDs[k], species = pathview.species, out.suffix = make.names(dimnames(wts.c)[[2]][1]),
                                                               kegg.native = FALSE,limit=list(gene=genelimit,cpd=c(-1,1)),gene.idtype="Symbol",multi.state=FALSE,same.layer=FALSE))))  
        }
      }
      d=TRUE
      print(paste("Creating pathview analysis results ",j,"/",J))
#      cat(paste("LOG: Creating pathview analysis results ",j,"/",J),file=log,sep='\n\n',append=TRUE)
#      cat(paste("document.write('<p>Creating pathview analysis results ",j,"/",J," </p>');"), file=paste(path.inc,"//status.js",sep=""),append=TRUE)
    }
  }
  setwd(maindir)
  print("Finished pathview analysis")
#  cat("LOG:Finished pathview analysis",file=log,sep='\n\n',append=TRUE)
  cat("document.write('<p>Finished pathview analysis</p>');", file=paste(path.inc,"//status.js",sep=""),append=TRUE)
  return(wtmp)
}